//
//  WDDevice.h
//  DriveUnlock
//
//  Created by Bob on 3/11/09.
//  Copyright 2013 Western Digital Technologies, Inc. All rights reserved.
//

#import <IOKit/IOCFPlugIn.h>
#import <IOKit/scsi/SCSITaskLib.h>
#import "WDDMInfoController.h"
#import <DiskArbitration/DiskArbitration.h>

//enum {
//	kDeviceSNLength	= 17,		// Length of device serial number
//	kFRUSNLength	= 21,		// Length of each of the FRU serial numbers
//	kTotalSNLength	= 59,		// Length of device and 2 FRU serial numbers 
//	kNameLength		= 256		// Name length
//};

typedef enum  {
    kUSB,
    kFW,
    kTB
}interfaceType;

//typedef struct 
//{
//	bool	eraseInProgress;
//	double	eraseProgressPercentage;
//} statusBlock;

@interface WDDeviceEraseProgress : NSObject {
	bool	eraseInProgress;
	double	percentageComplete;
}

@property (nonatomic, readwrite, assign)	bool	eraseInProgress;
@property (nonatomic, readwrite, assign)	double	percentageComplete;

@end

@interface WDDevice : NSObject {
	io_service_t				IOService;
	io_service_t				mSESPluginNub;
	io_service_t				mCDPluginNub;
	io_service_t				AppleAHCInterface;			// Start the search for disk drives here.
    bool                        deviceOpen;
	id							pidObject;
    
	IOCFPlugInInterface **		mPlugInIterface;
	SCSITaskDeviceInterface**	mSCSITaskDevInterface;
	SCSITaskInterface**			mSCSITaskInterface;
	
    WDDMInfoController *        mWDDMInfoController;        // set if we have a connection to WDDM.
    BOOL                        mWDDMControlled;            // TRUE if WDDM has this device open and therefore controlling the device.
    
	// Drive information

	UInt64                      mDeviceSize;
	UInt64                      mCDDeviceSize;
    UInt64                      mRawDeviceCapacity;
	NSString *					mSerialNumber;					// Serial number of the device.
	NSString *					mDeviceBSDName;					// device BSD Name if it has one.
	NSString *					mDeviceCDBSDName;				// device CD BSD Name if it has one.
	UInt32                      mProductID;						// product ID of the device.
	UInt16                      mFWVersion;						// Firmware version of device.
    interfaceType               mInterfaceType;					// Initer face type of device. (defined above)
	NSMutableArray *			mDisks;							// Array of WDDisk's in a device.
	BOOL						mCompositeDevice;				// Does this device contain other devices?
	NSLock *					mdeviceLock;
	int							mThunderboltPortNumber;			//
}

@property (readwrite,assign) io_service_t           IOService;
@property (readwrite,assign) io_service_t           mSESPluginNub;
@property (readwrite,assign) io_service_t           mCDPluginNub;
@property (readwrite,assign) io_service_t			AppleAHCInterface;

@property (readwrite,assign) UInt64                 mDeviceSize;
@property (readwrite,assign) UInt64                 mCDDeviceSize;
@property (readwrite,assign) UInt64                 mRawDeviceCapacity;
@property (readwrite,copy)	NSString *				mSerialNumber;
@property (readwrite,copy)	NSString *				mDeviceBSDName;
@property (readwrite,copy)	NSString *				mDeviceCDBSDName;
@property (readwrite,assign) UInt32                 mProductID;
@property (readwrite,assign) UInt16                 mFWVersion;
@property (readwrite,assign) interfaceType          mInterfaceType;
@property (readwrite,retain) NSMutableArray *		mDisks;
@property (readwrite,assign) BOOL					mCompositeDevice;
@property (readwrite,assign) int					mThunderboltPortNumber;
@property (readwrite,assign) WDDMInfoController *   mWDDMInfoController;
@property (readwrite,assign) BOOL                   mWDDMControlled;
-(NSDictionary *) deviceDictionary;

- (BOOL) writeHFSFormat: (bycopy NSString*) driveNode volumeName: (bycopy NSString*) volumeName;
- (void) dismount;
- (void) dismountVCD;
- (void) eject;
- (void) ejectVCD;
- (bool) updateThunderboltDisksForDevice;
- (void) writeZerosToDisk: (WDDeviceEraseProgress *) progressBlock;
- (int) dismountDisk: (id)sender;
- (void) deviceLock;
- (void) deviceUnLock;
- (void) enableWDDMSupport;

+ (NSString*) volumeFromBSDName:(NSString*)bsdName;
+ (NSArray*) volumesFromBSDName:(NSString*)bsdName;

+(int) setCustomIcon: (NSString *) iconName OnVolume: (NSString *) bsdName;
void SafeRemovalCallback( DADiskRef disk, DADissenterRef dissenter, void * context );

@end